---------------------------------------------------------------------------------------------------------
-- BEGIN HEADER
---------------------------------------------------------------------------------------------------------
-- DDL for Alkindi Schema Model Version 0.5
-- DDL to create packages and procedures
-- Myles Weber, Appian Corporation
-- Weber@AppianCorp.com
-- Date Created: September 12, 2000 MSW
-- Date Updated: October 5, 2000 MSW
---------------------------------------------------------------------------------------------------------
-- END HEADER
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- BEGIN CHANGE LOG SINCE VERSION 0.4
---------------------------------------------------------------------------------------------------------
-- WHO WHEN   WHAT
-- MSW 092700 Added Change Log
-- MSW 092700 Added Header Comments
-- AHW 092700 Changed error codes for all stored procedures
-- MSW 092700 Added 'SHOW ERRORS' statement after each package creation
-- MSW 092900 Added pkg_ALKINDI_SEARCH.sp_SEL_Movie_Advance to search for product_ids based upon movie criteria
---------------------------------------------------------------------------------------------------------
-- END CHANGE LOG SINCE VERSION 0.4
---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE PACKAGE pkg_ALKINDI_SEARCH
AS
  TYPE SEARCH_cursor_type is REF CURSOR;

  PROCEDURE sp_SEL_UserID_By_Screenname(
	i_SCREENNAME		IN		USER_DETAIL.SCREENNAME%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_Movie_Simple(
	i_FIELD			IN		VARCHAR2,
	i_CRITERIA			IN		VARCHAR2,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_Movie_Advance(
	i_TITLE			IN		MOVIE.TITLE%TYPE,
	i_MOVIE_DESC		IN		MOVIE.MOVIE_DESC%TYPE,
	i_ACTOR			IN		MOVIE.ACTOR%TYPE,
	i_DIRECTOR			IN		MOVIE.DIRECTOR%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

END pkg_ALKINDI_SEARCH;
/

-- ==========================================================================================

SHOW ERRORS

-- ==========================================================================================

CREATE OR REPLACE PACKAGE BODY pkg_ALKINDI_SEARCH
AS

  PROCEDURE sp_SEL_UserID_By_Screenname(						-- Search for USER_IDs that have a Screenname similar to the one submitted

	i_SCREENNAME		IN		USER_DETAIL.SCREENNAME%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
  IS 
	v_SEARCH_CRITERIA VARCHAR2(17);
  BEGIN
	o_ERROR_CODE	:= 0;
	v_SEARCH_CRITERIA	:= '%'||i_SCREENNAME||'%';

	OPEN o_SEARCH_cursor_type FOR
	SELECT USER_ID
	     , SCREENNAME
	  FROM USER_DETAIL
	 WHERE NLS_LOWER(SCREENNAME) LIKE NLS_LOWER(v_SEARCH_CRITERIA);

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6565;
		CLOSE o_SEARCH_cursor_type;
 END sp_SEL_UserID_By_Screenname;

-- ==========================================================================================

  PROCEDURE sp_SEL_Movie_Simple(
	i_FIELD			IN		VARCHAR2,
	i_CRITERIA			IN		VARCHAR2,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
  IS 
	v_SEARCH_CRITERIA VARCHAR2(2000);
  BEGIN
	o_ERROR_CODE	:= 0;
	v_SEARCH_CRITERIA:= '%'||i_FIELD||'%';

	OPEN o_SEARCH_cursor_type FOR
	SELECT *
	  FROM MOVIE;

 EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;
		CLOSE o_SEARCH_cursor_type;
 END sp_SEL_Movie_Simple;

-- ==========================================================================================

  PROCEDURE sp_SEL_Movie_Advance(
	i_TITLE			IN		MOVIE.TITLE%TYPE,
	i_MOVIE_DESC		IN		MOVIE.MOVIE_DESC%TYPE,
	i_ACTOR			IN		MOVIE.ACTOR%TYPE,
	i_DIRECTOR			IN		MOVIE.DIRECTOR%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)

  IS 
	v_SEARCH_TITLE		 VARCHAR2(2000);
	v_SEARCH_MOVIE_DESC	 VARCHAR2(2000);
	v_SEARCH_ACTOR		 VARCHAR2(2000);
	v_SEARCH_DIRECTOR		 VARCHAR2(2000);
  BEGIN
	o_ERROR_CODE		:= 0;
	v_SEARCH_TITLE		:= '%'||i_TITLE||'%';
	v_SEARCH_MOVIE_DESC	:= '%'||i_MOVIE_DESC||'%';
	v_SEARCH_ACTOR		:= '%'||i_ACTOR||'%';
	v_SEARCH_DIRECTOR		:= '%'||i_DIRECTOR||'%';


	OPEN o_SEARCH_cursor_type FOR
	SELECT PRODUCT_ID
	  FROM MOVIE
	 WHERE NLS_LOWER(TITLE)		LIKE NLS_LOWER(v_SEARCH_TITLE)
	   AND NLS_LOWER(MOVIE_DESC)	LIKE NLS_LOWER(v_SEARCH_MOVIE_DESC)
	   AND NLS_LOWER(ACTOR)		LIKE NLS_LOWER(v_SEARCH_ACTOR)
	   AND NLS_LOWER(DIRECTOR)	LIKE NLS_LOWER(v_SEARCH_DIRECTOR);

  EXCEPTION
  	WHEN OTHERS THEN
  		o_ERROR_CODE	:= 6567;
  		CLOSE o_SEARCH_cursor_type;
  END sp_SEL_Movie_Advance;

-- ==========================================================================================

END pkg_ALKINDI_SEARCH;
/

SHOW ERRORS
